/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.api;

import frc.emul.util.Utils;

public class MemoryAccessException
extends RuntimeException {
    public final int address;

    public MemoryAccessException(int n, Throwable throwable, boolean bl) {
        super(MemoryAccessException.buildReadMessage(n, bl), throwable);
        this.address = n;
    }

    public MemoryAccessException(int n, Throwable throwable, boolean bl, int n2) {
        super(MemoryAccessException.buildWriteMessage(n, bl, n2), throwable);
        this.address = n;
    }

    public int getAddress() {
        return this.address;
    }

    private static final String buildReadMessage(int n, boolean bl) {
        return "Error while reading " + (bl ? "byte" : "word") + " at $" + Utils.HEX4(n & 0xFFFF);
    }

    private static final String buildWriteMessage(int n, boolean bl, int n2) {
        String string = bl ? Utils.HEX2(n2 & 0xFF) : Utils.HEX4(n2 & 0xFFFF);
        return "Error while writing $" + string + " at $" + Utils.HEX4(n & 0xFFFF);
    }
}

